<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
include 'koneksi.php';

$jenis = $_GET['jenis'] ?? '';

if ($jenis != 'masuk' && $jenis != 'keluar') {
    echo json_encode(["success" => false, "message" => "Parameter jenis tidak valid (masuk/keluar)."]);
    exit;
}

$stmt = $conn->prepare("SELECT * FROM transaksi WHERE jenis = ? ORDER BY tanggal DESC");
$stmt->bind_param("s", $jenis);
$stmt->execute();
$result = $stmt->get_result();

$data = [];
while ($row = $result->fetch_assoc()) {
    $data[] = [
        "id" => $row['id'],
        "jenis" => $row['jenis'],
        "nominal" => $row['nominal'],
        "keterangan" => $row['keterangan'],
        "tanggal" => $row['tanggal']
    ];
}

echo json_encode([
    "success" => true,
    "message" => "Data transaksi jenis '$jenis' berhasil diambil.",
    "data" => $data
]);
?>
