<?php
header('Content-Type: application/json');
include 'koneksi.php';

// Pastikan request method adalah POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Ambil data dari request body
    $jenis = $_POST['jenis'] ?? '';
    $nominal = $_POST['nominal'] ?? '';
    $keterangan = $_POST['keterangan'] ?? '';

    // Validasi input
    if (empty($jenis) || empty($nominal) || empty($keterangan)) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Semua field harus diisi!'
        ]);
        exit;
    }

    // Simpan ke database
    $stmt = $conn->prepare("INSERT INTO transaksi (jenis, nominal, keterangan) VALUES (?, ?, ?)");
    $stmt->bind_param("sds", $jenis, $nominal, $keterangan);

    if ($stmt->execute()) {
        echo json_encode([
            'status' => 'success',
            'message' => "Transaksi $jenis berhasil disimpan!"
        ]);
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'Gagal menyimpan transaksi: ' . $stmt->error
        ]);
    }

    $stmt->close();
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Metode request tidak diizinkan!'
    ]);
}
?>
