<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
include 'koneksi.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $username = trim($_POST['username'] ?? '');
    $nama     = trim($_POST['nama'] ?? '');
    $email    = trim($_POST['email'] ?? '');
    $password = trim($_POST['password'] ?? '');

    if (empty($username) || empty($nama) || empty($email) || empty($password)) {
        echo json_encode(["success" => false, "message" => "Semua field wajib diisi."]);
        exit;
    }

    // Cek email atau username sudah digunakan
    $check = $conn->prepare("SELECT * FROM tb_user WHERE email = ? OR username = ?");
    $check->bind_param("ss", $email, $username);
    $check->execute();
    $result = $check->get_result();

    if ($result->num_rows > 0) {
        echo json_encode(["success" => false, "message" => "Email atau username sudah terdaftar."]);
        exit;
    }

    // Hash password
    $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

    // Simpan ke database
    $insert = $conn->prepare("INSERT INTO tb_user (username, nama, email, password) VALUES (?, ?, ?, ?)");
    $insert->bind_param("ssss", $username, $nama, $email, $hashedPassword);

    if ($insert->execute()) {
        echo json_encode(["success" => true, "message" => "Registrasi berhasil!"]);
    } else {
        echo json_encode(["success" => false, "message" => "Gagal menyimpan data."]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Metode tidak diizinkan."]);
}
?>
